import matplotlib.pyplot as plt
import numpy as np

filenames = ['scaling_m01_cpu.csv', 'scaling_m02_cpu.csv', 'scaling_m04_cpu.csv', 'scaling_m08_cpu.csv']
ns = [1, 2, 4, 8]

header  = ''
infile = open(filenames[0], 'r')
header = infile.readline().strip().split(',')

timings = []
for i in range(len(ns)):
    data = np.loadtxt(filenames[i], delimiter=',', skiprows=1)
    if len(data.shape)==1:
        timings.append(data)
    else:
        timings.append(data[0, :])

print(header)
print(timings)

columns = [1, 2, 3, 4, 5, 7, 11, 14]

for c in columns:
    y = []
    for i in range(len(ns)):
        y.append(timings[i][c])
    plt.plot(np.log2(ns), np.log2(y), '-o', label=header[c])

# plt.plot([ns[0], ns[-1]], [1./ns[0], 1./ns[-1]], ':', linewidth=3, color='gray')

plt.ylim(ymin=-5)
plt.grid()
plt.xticks(range(len(ns)), ns)
plt.xlabel("number of processes")
plt.ylabel("log2( execution time [s] )")

plt.legend(loc='best')
plt.savefig("scaling.pdf")
plt.show()
