# -*- coding: utf-8
import re
from Packages.language import fatal, trans
import numpy as np
import scipy    
from scipy.interpolate import interp1d
from Packages.logger import Logger

class CSV():
   '''  Parse input of FDS file related to different entities '''

   LABEL=0
   UNIT=1
   DATA=2

   class StateMachine:
      def __init__(self, states):
         self.states = states
         self.reset()

      def reset(self):
         self.state = self.states[0]
         self.stateIndex = 0

      def next(self):
         if self.stateIndex == 2: return
         self.stateIndex += 1
         self.state = self.states[self.stateIndex]

   def __init__(self, names, sep='', recodeLatin=True, stateMachine=StateMachine([UNIT, LABEL, DATA])):
      self.logger = Logger.Instance()
      self.duplicates = False
      data = []
      continued = False
      for name in names:
         index = 0
         for line in open(name, 'r'):
            if sep == '':
               counts = { '\t':0, ";":0, ",":0 }
               for c in line:
                  if c in counts: counts[c] += 1
               maxc = 0
               for key in counts:
                  n = counts[key]
                  if n > maxc:
                     maxc = n
                     sep = key
            if recodeLatin: line = line.decode('latin-1').encode('utf8')
            line = line.replace ("\n", '').replace ("\r", '').replace(' ', '').replace('\t', '')

            if continued:               
               data[index] += line[line.find(sep):]
               index += 1
               if (index >= len(data)): break
            else:
               data.append(line)
         continued = True

      self.values = {}
      self.units = None
      stateMachine.reset()
      lineNo = 0
      dataError = False
      for line in data: #read and store labels and contents of the different colums in CSV-file
         lineNo += 1
         if stateMachine.state == self.UNIT:
            stateMachine.next()
            self.units = line.split (sep)
            continue

         if stateMachine.state == self.LABEL:
            stateMachine.next()
            self.labels = []
            label = ''
            class State:

               def __init__(self):
                  self._inStr = 1
                  self._plain = 0
                  self.val = self._plain

               def set(self, val):
                  self.val = self.__dict__['_' + val]

               def isAt(self, val):
                  return self.val == self.__dict__['_' + val]

            state = State()
            for c in line:
               if state.isAt('plain'):
                  if c == sep:
                     self.labels.append(label)
                     label = ''
                  elif c == '"':
                     state.set('inStr')
                  else:
                     label += c
               else:
                  if c == '"':
                     state.set('plain')
                  else:
                     label += c
            self.labels.append(label)
            self.labelIndex = {}
            for labelNo in range(len(self.labels)):
               label = self.labels[labelNo]
               if label in self.labelIndex: self.duplicates = True
               self.labelIndex[label] = labelNo
               self.values[label] = []
            continue

         entries = []
         entries = line.split (sep)
         for i in range(len(entries)):
            try:
               self.values[self.labels[i]].append(float(entries[i].replace(",", ".")))
            except Exception as e:
               self.logger.log (trans("DataError") % (e, lineNo))
               self.logger.log (line)
               dataError = True
               break
         if dataError: break

      if not "Time" in self.labels:
         print (trans("DataErrorLength"))
         exit(0)
      times = self.values["Time"]
      t0 = times[0]
      minLen = 9e99
      for key in self.values.keys():
         minLen = min(minLen, len(self.values[key]))
      truncated = False
      for key in self.values.keys():
         if len(self.values[key]) == minLen: continue
         self.values[key] = self.values[key][:minLen]
         truncated = True
      if truncated: self.logger.log(trans("DataErrorLength"))

   def rename(self, old, new):
      index = self.labelIndex[old]
      self.labelIndex[new] = index
      self.labels[index] = new
      self.values[new] = self.values[old]

