# -*- coding: utf-8 -*-

from sys import exit

languageDef = {}
language = ""

def setupLanguage(lang = 'de'):
   global languageDef
   global language
   language = lang
   languageDef = makeLanguage({
      ('DataError', 'Datenfehler %s in Zeile %d:', 'Data error %s in line %d:'),
      ('DataErrorLength', 'Allgemeiner Datenfehler', 'General data error'),
      ('Energies', 'Wärmefreisetzungsrate', 'Heat release rates'),
      ('MissingQ', 'Die Quantity %s is in der Datei %s nicht vorhanden', 'Quantity %s is missing in file %s'),
      ('Q_DENSITY', 'Optische Dichte', 'Optical density'),
      ('Q_HRRPUV', 'HRR', 'HRR'),
      ('Q_TEMPERATURE', 'Temperatur', 'Temperature'),
      ('Q_VISIBILITY', 'Sichtweite', 'Visibility'),
      ('Q_OPTICAL DENSITY', 'Optische Dichte', 'Optical density'),
      ('Q_VELOCITY', 'Geschwindigkeit', 'Velocity'),
      ('Q_PRESSURE', 'Druck', 'Pressure'),
      ('TIMEplot', 'Zeit [$s$]', 'Time [$s$]'),
   }, lang)

def trans(sym):
   if sym in languageDef:
      return languageDef[sym]
   print 'Missing symbolic string %s' % sym
   return sym

def floatStr(fmt, val):
   global language
   res = fmt % val
   if language == 'de': return res.replace('.', ',')
   return res

def makeLanguage(strings, lang):
   res = {}
   for code, de, en in strings:
      if code in res:
         print "Duplicate language key %s" % code
      else:
         if lang == 'de':
            res[code] = de
         else:
            res[code] = en
   return res

def fatal(msg, sub=None):
   msg = trans(msg)
   if sub:
      msg = msg % sub
   print msg
   exit(-1)
