# -*- coding: utf-8
import math
import matplotlib
matplotlib.use('tkagg')
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
from pylab import savefig
from Packages.language import trans, fatal, floatStr
from Packages.utils import timeFormat, makePath
import matplotlib.font_manager as fnt
from matplotlib.path import Path
from matplotlib.patches import PathPatch, Rectangle
from matplotlib.cm import get_cmap
from matplotlib.colors import LinearSegmentedColormap
import matplotlib.colors as colors
import numpy as np
from scipy.interpolate import spline
from scipy import interpolate
import warnings
from Packages.logger import Logger

class Plot():
   COLORS = ['#0000ff', '#00ff00', '#ff0000',
      '#ff00ff', '#00ffff', #'#ffff00',
      '#000080', '#008000', '#800000',
      '#008080', '#808000', '#800080',
      '#8000ff', '#00ff80', '#ff8000',
      '#ff80ff', '#80ffff', '#ffff80',
   ]
   CPUCOLORS = {}
   index = 0
   for routine in ['MAIN', 'DIVG', 'MASS', 'VELO', 'PRES', 'WALL', 'DUMP', 'PART', 'RADI', 'FIRE', 'COMM', 'EVAC', 'HVAC']:
      CPUCOLORS[routine] = COLORS[index]
      index += 1
   REMAINCOLOR = COLORS[-1]
   MARKERS = ["s","D","o","v","h",">","d","<","H","*"]
   
   def __init__(self, plotType='xy', highlight=None):
      self.logger = Logger.Instance()
      fig = plt.figure (facecolor='w')
      if plotType == 'xy' or plotType == 'timer':
         self.subplot = fig.add_subplot(111)
      else:
         fatal('Invalid plot type' + plotType)
      self.ymin =  1e+10
      self.ymax = -1e+10
      self.xmin =  1e+10
      self.xmax = -1e+10

   def __getattr__(self, name):
      return getattr(self.subplot,name)

   def close(self, filename):
      self.logger.log ("Plot " + filename)
      makePath(filename)
      savefig(filename)
      plt.close()


   def xyGraph(self, values, timeValues, styleIndex=-1, single=True, overlay=1, overlays=1, final=True, yrange=None):
      offset = len(values)/(overlays+2)*overlay

      self.xmin = min(min(timeValues), self.xmin)
      self.xmax = max(max(timeValues), self.xmax)
      self.ymin = min(min(values), self.ymin)
      self.ymax = max(max(values), self.ymax)

      if single: width = 1.0
      else: width= 0.8

      styleIndex = overlay-1
      if single: 
         marker = None
         mark = None
      else: 
         marker = self.MARKERS[styleIndex%len(self.MARKERS)]
         mark =  (offset, len(timeValues))
      self.ymin = min(min(values),self.ymin)
      self.ymax = max(max(values),self.ymax)

      self.subplot.plot (timeValues, values, \
         color = self.COLORS[styleIndex%len(self.COLORS)], \
         marker = marker, \
         linestyle = "-", \
         linewidth = width, \
         markevery = mark )

      if not final: return

      self.subplot.grid(True)

      labels = self.subplot.get_xticklabels() + self.subplot.get_yticklabels()
      for label in labels:
         label.set_size(10)

      box = self.subplot.get_position()
      self.subplot.set_position([box.x0, box.y0 + box.height * 0.15, box.width, box.height * 0.85])

      self.subplot.set_xlim(self.xmin, self.xmax)
      space = (self.ymax - self.ymin) / 10.0
      if yrange != None:
         self.subplot.set_ylim(yrange[0], yrange[1])
         self.subplot.set_autoscale_on(False)
      elif space > 0:
         self.subplot.set_ylim(self.ymin-space, self.ymax+space)
         self.subplot.set_autoscale_on(False)

      self.subplot.set_xlim(self.xmin, self.xmax)

   def intTicks(self):
      dist = max(1, int((self.ymax-self.ymin)/4))
      ticks = np.arange(self.ymin, self.ymax+dist, dist)
      if ticks[-1] != self.ymax and len(ticks) > 1: 
         ticks[-1] = self.ymax
         r = (self.ymax - float(ticks[0])) / len(ticks) / 3
         if (ticks[-1] - ticks[-2]) < r: ticks = ticks[:-1]

      plt.yticks(ticks)
      self.subplot.set_yticklabels([str(i) for i in ticks])

   def title(self, title):
      plt.title(title, size=20)

   def label(self, quantity, unit=None, xlabel=None):
      if xlabel is None: xlabel = trans('TIMEplot')
      self.subplot.set_xlabel(xlabel, fontsize=16)
      if quantity is None: return
      qLabel = quantity.decode('utf8')
      if not unit is None: qLabel += ' [%s]' % unit
      self.subplot.set_ylabel(qLabel, fontsize=16)

   def legend(self, choices):
      # Put a legend below current axis
      columns = len(choices)
      if columns > 4: columns = int(math.sqrt(columns)+2)
      rows = len(choices)/columns
      legsize = fnt.FontProperties(size=12)
      self.subplot.legend(choices, prop=legsize, loc="lower center", bbox_to_anchor=(0.50, -0.25-(rows*0.025)), fancybox=True, shadow=True, ncol=columns)


