# -*- coding: utf-8 -*-
import os

def makePath(path):
   parent = os.path.dirname(path)
   if parent == '': return
   if os.path.exists(parent): return
   makePath(parent)
   os.makedirs(parent)

def makeDir(path):
   makePath(os.path.join(path, "dummy"))

def findFreeFile(pre, post):
   if not os.path.exists(pre+post): return pre+post
   index = 1
   while True:
      filename = "%s_%d%s" % (pre, index, post)
      if not os.path.exists(filename): return filename
      index += 1

def timeFormat(time, daySep='d\n'):
   if type(time) is int:
      day = int(time/86400)
      s = time - day * 86400
   else:
      day = time.days
      s = time.seconds

   if day > 0: res = "%d %s" % (day, daySep)
   else: res = ""

   if s >= 3600 or day > 0:
      h = int(s/3600)
      s -= h*3600
      res += "%2.2d:" % h

   return res + "%2.2d" % int(s/60)