import os
import sys
import numpy as np
import scipy

from Packages.fdscsv import CSV
from Packages.plot import Plot
from Packages.language import setupLanguage, trans

setupLanguage('en')

def help():
    print "Usage %s <csvfiles> [-o <plot> <value> ]" % sys.argv[0]
    print " where <value> can be any Quantity appearing in all of the specified <csvfiles>"
    print " <csvfile> is a blank separated list of full paths to the csv files containing the plot data"
    print " <plot> is the optional name of the output file. If not specified an accordingly named png will be created in a pictures sub-folder."
    exit (0)

if len(sys.argv) < 3: help()
quantity = sys.argv[-1]
quantityU = quantity.upper()
unit = None

plotFile = None
atFile = False
atRange = False
atInput = False
inputFiles = None
yrange = None
csvData = []
maxTimes = 0
minTime = 1e99
maxTime = 0
minLen = 1e99
chids = []

def processFile(csvFile):
    global quantity, csvData, maxTimes, minTime, maxTime, minLen, unit, chids

    if csvFile == "": return
    if not os.path.exists(csvFile): 
        print "File %s does not exist" % csvFile
        exit(0)
    csv = CSV([csvFile], recodeLatin=False, stateMachine=CSV.StateMachine([CSV.UNIT, CSV.LABEL, CSV.DATA]))
    upperQ = [v.upper() for v in csv.labels]
    indices = [i for i,x in enumerate(upperQ) if x == quantityU]
    if len(indices) == 0:
        print (trans("MissingQ") % (quantity, csvFile))
        exit(0)
    idx = indices[0]
    if unit == None:
        unit = csv.units[idx]
    elif unit != csv.units[idx]:
        print "Unit for %s differs in files" % unit
    quantity = csv.labels[idx]
    (csvName, _) = os.path.splitext(os.path.basename(csvFile))
    if csvName[-3:] == "hrr":
        chid = csvName[:-4]
    else:
        chid = csvName[:-5]
    chids.append(chid)
    times = csv.values['Time']
    values = csv.values[quantity]
    csvData.append((chid, times, values))
    maxTimes = max(maxTimes, len(times))
    maxTime = max(maxTime, times[-1])
    minTime = min(minTime, times[0])
    minLen = min(minLen, len(times))

for i in range(1, len(sys.argv)-1):
    arg = sys.argv[i]
    argU = arg.upper()
    if atFile:
        plotFile = sys.argv[i]
        atFile = False
        continue
    if argU == "-O":
        atFile = True
        continue

    if atRange:
        yrange = [float(v) for v in arg.split("-")]
        atRange = False
        continue
    if argU == "-R":
        atRange = True
        continue

    if atInput:
        if not os.path.exists(arg): 
            print "File %s does not exist" % arg
            exit(0)
        with open(arg, 'r') as infile:
            data = infile.read().split('\n')
        for csvFile in data:
            processFile(csvFile)
        atInput = False
        continue
    if argU == "-I":
        atInput = True
        continue

    processFile(arg)


plot = Plot()
curveOnly = False
lastC = chids[-1]
overlay = 1
for (chid, times, values) in csvData:
    chids.append(chid)
    plot.xyGraph(values, times, yrange=yrange, single=False, overlay=overlay, overlays=len(csvData), final=chid==lastC)
    overlay += 1
if unit != "":
    plot.label(quantity, "$%s$"%unit)
plot.legend(chids)
if plotFile == None:
    plotFile = "pictures/" + quantity + ".png"
plot.close(plotFile)
