import os
import sys

from Packages.fdscsv import CSV
from Packages.plot import Plot
from Packages.language import setupLanguage, trans

setupLanguage('en')

def help():
    print "Usage %s <csvfile> <values> [-o <plot>]" % sys.argv[0]
    print " where <csvfile> is full path to the csv file containing the plot data"
    print " <values> can be any list of Quantites appearing in the specified <csvfile>"
    print " <plot> is the optional name of the output file. If not specified an accordingly named png will be created in a pictures sub-folder."
    exit (0)

if len(sys.argv) < 2: help()
csvFile = sys.argv[1]
if not os.path.exists(csvFile): help()
csvPath = os.path.dirname(csvFile)
(csvName, _) = os.path.splitext(os.path.basename(csvFile))
if csvName[-3:] == "hrr":
    chid = csvName[:-4]
else:
    chid = csvName[:-5]

csv = CSV([csvFile], recodeLatin=False, stateMachine=CSV.StateMachine([CSV.UNIT, CSV.LABEL, CSV.DATA]))
quantities = []
def listQuantites(wrong=None):
    if wrong != None: print "Quantity %s is not available" % wrong
    print "Available quantities in %s are" % csvFile
    print ", ".join(csv.labels[1:-1]), "and", csv.labels[-1]
    exit(0)

unit = None
plotFile = None
atFile = False
upperQ = [v.upper() for v in csv.labels]
for i in range(2, len(sys.argv)):
    if atFile:
        plotFile = sys.argv[i]
        atFile = False
        continue
    quantity = sys.argv[i].upper()
    if quantity == "-O":
        atFile = True
        continue
    indices = [i for i,x in enumerate(upperQ) if x == quantity]
    if len(indices) == 0: listQuantites(quantity)
    quantity = csv.labels[indices[0]]
    quantities.append(quantity)
    idx = csv.labelIndex[quantity]
    if unit == None:
        unit = csv.units[idx]
    elif unit != csv.units[idx]:
        print "Can only plot multiple data if the are of the same unit (%s vs. %s)" % (unit, csv.units[idx])
        exit(0)
if len(quantities) == 0: listQuantites()
timeValues = csv.values['Time']
plot = Plot()
overlay = 1
single = len(quantities) == 1
lastQ = quantities[-1]
for quantity in quantities:
    plot.xyGraph(csv.values[quantity], timeValues, single=single, overlay=overlay, final=quantity==lastQ)
    overlay += 1
if unit != "":
    plot.label("", "$%s$"%unit)
plot.legend(quantities)
plot.title(chid)
if plotFile == None:
    plotFile = "pictures/" + "_".join(quantities) + ".png"
plot.close(plotFile)
