import os
import sys
from subprocess import call

def help():
    print "Usage %s <fdsfile> <command>" % sys.argv[0]
    print " where <fdsfile> is full path to the fds file to be split"
    print " and <command> can either be "
    print "  'run' - to run all splits consecutively or"
    print "  the split factors. E.g. 2x2 for a 2D split or 3x1x4 for a 3D split."
    exit (0)

if len(sys.argv) != 3: help()
fdsFile = sys.argv[1]
if not os.path.exists(fdsFile): help()
fdsPath = os.path.dirname(fdsFile)
(fdsName, _) = os.path.splitext(os.path.basename(fdsFile))
inputDir = os.path.join(fdsPath, "input")

command = sys.argv[2]
if command == "run":
    if not os.path.exists(inputDir):
        print "No input directory found:", inputDir 
        exit(0)

    fdsExe = os.path.expandvars('$FDS_EXE')
    if not os.path.exists(fdsExe):
        print "Environment variable $FDS_EXE not valid"
        exit(0)

    for subdir, dirs, files in os.walk(inputDir):
        for file in files:
            (caseName, _) = os.path.splitext(file)
            print "Processing", caseName
            targetDir = os.path.join(fdsPath, 'cases', caseName)
            call (['mkdir', '-p', targetDir])
            call (['cp', os.path.join(subdir, file), targetDir])
            print targetDir
            call (['cd', targetDir])
            call (['mpirun', '-np', '1', fdsExe, file])
            
    exit(0)
    
split = command    
try:
    splits = [int(i) for i in split.split('x')]
except:
    help()

with open(fdsFile, 'r') as fdsfile:
    data = fdsfile.read().split('\n')

hasMesh = False
headLine = None
headLine1 = None
headLine1Pos = None
for line in data:
    if line[:5] == "&HEAD":
        pos = line.index("CHID")
        pos2 = line[pos+6:].index("'")
        pos += pos2+6
        headLine1 = line
        if line[pos-4:pos] == "_1x1":
            headLine = line[:pos-4] + "_" + command + line[pos:]
        elif line[pos-6:pos] == "_1x1x1":
            headLine = line[:pos-6] + "_" + command + line[pos:]
        else:
            headLine = line[:pos] + "_" + command + line[pos:]
            headLine1Pos = pos
            
        continue
    if line[:5] != "&MESH": continue
    if hasMesh:
        print "Can not process complex fds with more than one MESH"
        exit(0)
    hasMesh = True
    meshLine = line
if not hasMesh:
    print "fds file has no MESH defined"
    exit(0)
ijkPos = meshLine.find("IJK=")
xbPos = meshLine.find("XB=")

def parseError():
    print "can not parse MESH instruction:", meshLine
    exit(0)

if ijkPos < 0 or xbPos < 0: parseError()

def getNumbers(pos, n):
    res = []
    token = ""
    while True:
        pos += 1
        if pos >= len(meshLine): break
        c = meshLine[pos]
        if c == " ": continue
        if c == "/": break
        if c == ",":
            if n == 1: break
            res.append(token)
            n -= 1
            token = ""
        else:
            token += c
    if token == "": parseError()
    res.append(token)
    return res
try:
    ijk = [int(i) for i in getNumbers(ijkPos+3, 3)]
    xb = [float(n) for n in getNumbers(xbPos+2, 6)]
except:
    parseError()

twoDim = 1 in ijk
if headLine1Pos != None:
    infix = "_1x1" if twoDim else "_1x1x1"
    headLine1 = headLine1[:headLine1Pos] + infix + headLine1[headLine1Pos:]
dims = 2 if twoDim else 3
if len(splits) != dims:
    dimStr = "two" if twoDim else "three"
    print "Splits %s does not match %s-dimensional mesh", (splits, dimStr)
    exit(0)
if twoDim:
    idx = ijk.index(1)
    if idx == 0:
        (i,j,k) = (1, splits[0], splits[1])
        ijk1 = (1, ijk[1] / splits[0], ijk[1] / splits[1])
    elif idx == 1:
        (i,j,k) = (splits[0], 1, splits[1])
        ijk1 = (ijk[0] / splits[0], 1, ijk[2] / splits[1])
    else:
        (i,j,k) = (splits[0], splits[1], 1)
        ijk1 = (ijk[0] / splits[0], ijk[1] / splits[1], 1)
else:
    ijk1 = [ijk[i] / splits[i] for i in range(3)]
    (i, j, k) = splits
dx = (xb[1] - xb[0]) / i
dy = (xb[3] - xb[2]) / j
dz = (xb[5] - xb[4]) / k
xb[1] = xb[0] + dx
xb[3] = xb[2] + dy
xb[5] = xb[4] + dz
mesh1 = "&MESH IJK=%s, XB=%s, MULT_ID='mesh' /" % (', '.join([str(c) for c in ijk1]), ', '.join([str(c) for c in xb]))
mesh2 = "&MULT ID='mesh', DX=%.2f, DY=%.2f, DZ=%.2f, I_UPPER=%d, J_UPPER=%d, K_UPPER=%d /" % (dx, dy, dz, i-1, j-1, k-1)
meshNew = mesh1 + "\n" + mesh2

if not os.path.exists(inputDir):
    call(['mkdir', "-p", inputDir])
fdsfile = open(os.path.join(inputDir, fdsName + "_" + split + ".fds"), "w")
for line in data:
    if line[:5] == '&MESH': line = meshNew
    elif line[:5] == "&HEAD": line = headLine
    fdsfile.write(line + "\n")
fdsfile.close()
if twoDim: infix = ""
else: infix = "x1"
fdsfile = open(os.path.join(inputDir, fdsName + "_1x1" + infix + ".fds"), "w")
for line in data:
    if line[:5] == "&HEAD": line = headLine1
    fdsfile.write(line + "\n")
fdsfile.close()
